/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)87       1.3  src/avs/fs/mmfs/ts/kernext/ibm-linux/cxiCred-plat.h, mmfs, avs_remp, rempt1d1 9/19/01 00:08:39 */
#ifndef _h_CXICRED_PLAT
#define _h_CXICRED_PLAT

/* Internal extended credential. */
struct ext_cred_t
{
  cxiUid_t principal;          /* user id */
  cxiGid_t group;              /* primary group id */

  UInt16   num_groups;         /* number secondary groups for this user */
#define ECRED_NGROUPS 32
  gid_t eGroups[ECRED_NGROUPS];/* array of secondary groups */
};

typedef struct ext_cred_t ext_cred_t;

#ifdef CONFIG_NSS
/*
 * Reserved group region for tokens
 * These are the group regions similar to those used by AFS.
 * 2^10 * 2^14 = 2^14 possible token values
 * (~16 million concurrent sessions)
 * Note: A user that has the first two groups within the range below will be
 * identified as having a PAG.
 */

#define NSS_PAG_LO1 34816
#define NSS_PAG_HI1 35840
#define NSS_PAG_LO2 32512
#define NSS_PAG_HI2 48896
#define NSS_PAGS    ((NSS_PAG_HI1 - NSS_PAG_LO1) * (NSS_PAG_HI2 - NSS_PAG_LO2))

/*
 * Macros for manipulating token indexes for PAGs
 */

#define HAS_PAG(groups) (groups[0] >= NSS_PAG_LO1 && groups[0] <= NSS_PAG_HI1 && groups[1] >= NSS_PAG_LO2 && groups[1] <= NSS_PAG_HI2)

#endif /* CONFIG_NSS */

#endif /* _h_CXICRED_PLAT */
